<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class AttendanceClean extends Model 
{

    protected $table = 'attendance_clean';
    public $timestamps = true;
    protected $fillable = array('attendance_id', 'file_id', 'pernr', 'personnel_area', 'org_unit', 'date', 'time', 'type', 'status_sent', 'sent_date', 'created_by', 'updated_by', 'message');

    public function files()
    {
        return $this->belongsTo('App\Model\Files', 'file_id');
    }

    public function attendance()
    {
        return $this->belongsTo('App\Model\Attendance', 'attendance_id');
    }

}